/*
 * Decompiled with CFR 0.152.
 */
package tech.kongolian.PasswordManagerCLI;

public class PasswordGenerator {
    public int length;
    public int type;

    public PasswordGenerator(int length, int type) {
        this.length = length;
        this.type = type;
    }

    public String GeneratePassword() {
        return switch (this.type) {
            case 1 -> this.GeneratePasswordForLowercase();
            case 2 -> this.GeneratePasswordForUppercase();
            case 3 -> this.GeneratePasswordForNumbers();
            case 4 -> this.GeneratePasswordForLetters();
            case 5 -> this.GeneratePasswordForLettersAndNumbers();
            case 6 -> this.GeneratePasswordForLettersNumbersAndSymbols();
            default -> this.GeneratePasswordForLowercase();
        };
    }

    public String GeneratePasswordForLowercase() {
        Object password = "";
        for (int i = 0; i < this.length; ++i) {
            password = (String)password + (char)(Math.random() * 26.0 + 97.0);
        }
        return password;
    }

    public String GeneratePasswordForUppercase() {
        Object password = "";
        for (int i = 0; i < this.length; ++i) {
            password = (String)password + (char)(Math.random() * 26.0 + 65.0);
        }
        return password;
    }

    public String GeneratePasswordForNumbers() {
        Object password = "";
        for (int i = 0; i < this.length; ++i) {
            password = (String)password + (char)(Math.random() * 10.0 + 48.0);
        }
        return password;
    }

    public String GeneratePasswordForLetters() {
        Object password = "";
        for (int i = 0; i < this.length / 2; ++i) {
            password = (String)password + (char)(Math.random() * 26.0 + 97.0);
            password = (String)password + (char)(Math.random() * 26.0 + 65.0);
        }
        if (this.length % 2 == 0) {
            return password;
        }
        password = (String)password + (char)(Math.random() * 26.0 + 97.0);
        return password;
    }

    public String GeneratePasswordForLettersAndNumbers() {
        Object password = "";
        for (int i = 0; i < this.length / 3; ++i) {
            password = (String)password + (char)(Math.random() * 26.0 + 97.0);
            password = (String)password + (char)(Math.random() * 26.0 + 65.0);
            password = (String)password + (char)(Math.random() * 10.0 + 48.0);
        }
        if (this.length % 3 == 0) {
            return password;
        }
        if (this.length % 3 == 1) {
            password = (String)password + (char)(Math.random() * 26.0 + 97.0);
            return password;
        }
        password = (String)password + (char)(Math.random() * 26.0 + 97.0);
        password = (String)password + (char)(Math.random() * 10.0 + 48.0);
        return password;
    }

    public String GeneratePasswordForLettersNumbersAndSymbols() {
        Object password = "";
        for (int i = 0; i < this.length / 4; ++i) {
            password = (String)password + (char)(Math.random() * 26.0 + 97.0);
            password = (String)password + (char)(Math.random() * 26.0 + 65.0);
            password = (String)password + (char)(Math.random() * 10.0 + 48.0);
            password = (String)password + (char)(Math.random() * 10.0 + 33.0);
        }
        if (this.length % 4 == 0) {
            return password;
        }
        if (this.length % 4 == 1) {
            password = (String)password + (char)(Math.random() * 26.0 + 97.0);
            return password;
        }
        if (this.length % 4 == 2) {
            password = (String)password + (char)(Math.random() * 26.0 + 97.0);
            password = (String)password + (char)(Math.random() * 10.0 + 48.0);
            return password;
        }
        if (this.length % 4 == 3) {
            password = (String)password + (char)(Math.random() * 26.0 + 97.0);
            password = (String)password + (char)(Math.random() * 10.0 + 48.0);
            password = (String)password + (char)(Math.random() * 10.0 + 33.0);
            return password;
        }
        password = (String)password + (char)(Math.random() * 26.0 + 97.0);
        password = (String)password + (char)(Math.random() * 26.0 + 65.0);
        password = (String)password + (char)(Math.random() * 10.0 + 48.0);
        password = (String)password + (char)(Math.random() * 10.0 + 33.0);
        return password;
    }
}

